// --------------------------------------------------------------------
// gif2jpg.cxx
// Whatis:  Converts a GIF image to JPG
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CPictureSourceGIF.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPicture.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {

	if	( aAc < 3 ) {
		::printf( "Usage; jpg2gif source target [x-size y-size]\n" );
		return	0;
	}

	try	{
		CPictureSourceGIF		gif( aAv[1] );
		CPictureSourceJPG		jpg( aAv[2] );
		CPicture				picture;
		picture.Load( gif );

		if	( aAc > 4 ) {
			CPictureFilterScale	scale( atol( aAv[3] ), atol( aAv[4] ) );
			picture.Filter( scale );
		}

		picture.Save( jpg );
	}

	catch	( CError e ) {
		::printf( "gif2jpg: ERROR : %s\n", e.Error() );
	}

	catch	( ... ) {
		::printf( "gif2jpg: ERROR : Unknown error\n" );
	}

    return	0;
}

// --------------------------------------------------------------------
// EOF: gif2jpg.cxx
// --------------------------------------------------------------------
