// --------------------------------------------------------------------
// jpg2gif.cxx
// Whatis:  Converts a JPG image to GIF
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CPictureSourceGIF.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPicture.hxx"

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {

	if	( aAc < 3 ) {
		::printf( "Usage; jpg2gif source target [x-size y-size]\n" );
		return	0;
	}

	try	{
		CPictureSourceGIF		gif( aAv[2] );
		CPictureSourceJPG		jpg( aAv[1] );
		CPicture				picture;
		picture.Load( jpg );

		if	( aAc > 4 ) {
			CPictureFilterScale	scale( atol( aAv[3] ), atol( aAv[4] ) );
			picture.Filter( scale );
		}

		picture.Save( gif );
	}

	catch	( CError e ) {
		::printf( "jpg2gif: ERROR : %s\n", e.Error() );
	}

	catch	( ... ) {
		::printf( "jpg2gif: ERROR : Unknown error\n" );
	}

    return	0;
}

// --------------------------------------------------------------------
// EOF: jpg2gif.cxx
// --------------------------------------------------------------------
