// --------------------------------------------------------------------
// CUnObjectFlags.hxx
// Whatis:  Unreal object flags
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnObjectFlags_hxx
#define CUnObjectFlags_hxx
#include    "CUnFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnObjectFlags class
// --------------------------------------------------------------------
class   CUnObjectFlags {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnObjectFlags ( CUnFile & );
    CUnObjectFlags ();

    // ----------------------------------------------------------------
    public:     // Certain assignment operators
    // ----------------------------------------------------------------
    CUnObjectFlags & operator = ( dword_t aDw );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnObjectFlags();

    // ----------------------------------------------------------------
    public: // Accessing instance data
    // ----------------------------------------------------------------
    dword_t     Flags           ( void ) const;
    bool        Transactional   ( void ) const;
    bool        Unreachable     ( void ) const;
    bool        Public          ( void ) const;
    bool        TagImp          ( void ) const;
    bool        TagExp          ( void ) const;
    bool        SourceModified  ( void ) const;
    bool        TagGarbage      ( void ) const;
    bool        NeedLoad        ( void ) const;
    bool        HighlightedName ( void ) const;
    bool        EliminateObject ( void ) const;
    bool        InSingularFunc  ( void ) const;
    bool        RemappedName    ( void ) const;
    bool        Suppress        ( void ) const;
    bool        StateChanged    ( void ) const;
    bool        InEndState      ( void ) const;
    bool        Transient       ( void ) const;
    bool        PreLoading      ( void ) const;
    bool        LoadForClient   ( void ) const;
    bool        LoadForServer   ( void ) const;
    bool        LoadForEdit     ( void ) const;
    bool        Standalone      ( void ) const;
    bool        NotForClient    ( void ) const;
    bool        NotForServer    ( void ) const;
    bool        NotForEdit      ( void ) const;
    bool        Destroyed       ( void ) const;
    bool        NeedPostLoad    ( void ) const;
    bool        HasStack        ( void ) const;
    bool        Native          ( void ) const;
    bool        Marked          ( void ) const;
    bool        ErrorShutdown   ( void ) const;
    bool        DebugPostLoad   ( void ) const;
    bool        DebugSerialize  ( void ) const;
    bool        DebugDestroy    ( void ) const;
    dword_t     ContextFlags    ( void ) const;
    dword_t     LoadContextFlags( void ) const;
    dword_t     LoadFlags       ( void ) const;
    bool        Keep            ( void ) const;
    dword_t     ScriptFlags     ( void ) const;

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t     itsFlags;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnObjectFlags               CUnObjectFlags_t;
typedef class CUnObjectFlags *             CUnObjectFlags_tp;
typedef list <class CUnObjectFlags>        CUnObjectFlags_tl;
typedef CUnObjectFlags_tl::iterator        CUnObjectFlags_tli;
typedef CUnObjectFlags_tl::const_iterator  CUnObjectFlags_tlci;

#endif  // #ifdef  CUnObjectFlags_hxx
// --------------------------------------------------------------------
// EOF: CUnObjectFlags.hxx
// --------------------------------------------------------------------
