//=============================================================================
// SkyBox1000Stars.
//=============================================================================
class SkyBox1000Stars expands BrushBuilder;

#exec OBJ LOAD FILE=..\Textures\GenFX.utx

var() LevelInfo LevelInfo;
var() int CountStars;
var() bool FullSphere;

event bool Build() {
	local SkyZoneInfo skybox;
	local Light star;
	local float r, v, a, b, s;
	local int i;
	local vector D;

	if (LevelInfo == None) {
		SetPropertyText("LevelInfo", "MyLevel.LevelInfo0");
		if (LevelInfo == None) SetPropertyText("LevelInfo", "MyLevel.LevelInfo1");
		if (LevelInfo == None) SetPropertyText("LevelInfo", "MyLevel.LevelInfo2");
		if (LevelInfo == None) {
			return BadParameters("Please specify LevelInfo");
		}
	}

	foreach LevelInfo.AllActors(class'SkyZoneInfo', skybox) {
		for (i = 0; i < CountStars; i++) {
			r = Rand(156) + 100;
			v = Rand((90 + 45)*360);
			a = (v % 360)/180*PI;
			b = ((v / 360) % 90)/180*PI;
		
			D.x = r*cos(b)*cos(a);
			D.y = r*cos(b)*sin(a);
			D.z = r*sin(b);
			if (FullSphere && Rand(100) < 50) D.z = -D.z;
			star = LevelInfo.Spawn(class'Light', LevelInfo, '', skybox.Location + D);
			star.bHidden = False;
			star.SetPropertyText("Style", "STY_Translucent");
			switch (rand(21)) {
				case 0: star.Texture = Texture'GenFX.LensFlar.dot_a'; s = 4.0; break;
				case 1: star.Texture = Texture'GenFX.LensFlar.dot_b'; s = 3.5; break;
				case 2: star.Texture = Texture'GenFX.LensFlar.dot_c'; s = 1.5; break;
				case 3: star.Texture = Texture'GenFX.LensFlar.dotblue'; s = 4.0; break;
				case 4: star.Texture = Texture'GenFX.LensFlar.dotgrn'; s = 4.0; break;
				case 5: star.Texture = Texture'GenFX.LensFlar.dotpink'; s = 4.0; break;
				case 6: star.Texture = Texture'GenFX.LensFlar.flare2'; s = 1.5; break;
				case 7: star.Texture = Texture'GenFX.LensFlar.flare3'; s = 2.0; break;
				case 8: star.Texture = Texture'GenFX.LensFlar.flare4'; s = 2.0; break;
				case 9: star.Texture = Texture'GenFX.LensFlar.flare5'; s = 2.5; break;
				case 10: star.Texture = Texture'GenFX.LensFlar.flare6'; s = 1.5; break;
				case 11: star.Texture = Texture'GenFX.LensFlar.flare7'; s = 1.0; break;
				case 12: star.Texture = Texture'GenFX.LensFlar.haze1'; s = 4.0; break;
				case 13: star.Texture = Texture'GenFX.LensFlar.haze2'; s = 4.0; break;
				case 14: star.Texture = Texture'GenFX.LensFlar.lens1'; s = 1.5; break;
				case 15: star.Texture = Texture'GenFX.LensFlar.lens2'; s = 2.0; break;
				case 16: star.Texture = Texture'GenFX.LensFlar.new1'; s = 4.0; break;
				case 17: star.Texture = Texture'GenFX.LensFlar.new2'; s = 4.0; break;
				case 18: star.Texture = Texture'GenFX.LensFlar.new3'; s = 2.0; break;
				case 19: star.Texture = Texture'GenFX.LensFlar.softlens'; s = 2.0; break;
				case 20: star.Texture = Texture'GenFX.LensFlar.softlens2'; s = 2.0; break;
//				case 21: star.Texture = Texture'GenFX.LensFlar.lensgr~1'; s = 1.5; break;
//				case 22: star.Texture = Texture'GenFX.LensFlar.flarel~6'; s = 1.0; break;
//				case 23: star.Texture = Texture'GenFX.LensFlar.1'; s = 1.5; break;
//				case 24: star.Texture = Texture'GenFX.LensFlar.2'; s = 1.5; break;
//				case 25: star.Texture = Texture'GenFX.LensFlar.3'; s = 1.5; break;
//				case 26: star.Texture = Texture'GenFX.LensFlar.5'; s = 2.0; break;
//				case 27: star.Texture = Texture'GenFX.LensFlar.6'; s = 1.5; break;
			}			
			star.DrawScale = 0.01*(RAND(2) + 1)/s;
			star.bUnlit = True;
			star.LightBrightness = 0;
			star.LightRadius = 0;
		}

		return BadParameters("Stars to skybox added!");
	}
	return BadParameters("First add SkyZoneInfo to the level.");
}

defaultproperties {
	BitmapFilename="SkyBox1000Stars"
	ToolTip="SkyBox 1000 stars"
	CountStars=1000
}
