//=============================================================================
// EditActor.
//=============================================================================
class EditActor expands BrushBuilder;

var() LevelInfo LevelInfo;

event bool Build() {
	local Actor actor, a;

	if (LevelInfo == None) {
		SetPropertyText("LevelInfo", "MyLevel.LevelInfo0");
		if (LevelInfo == None) SetPropertyText("LevelInfo", "MyLevel.LevelInfo1");
		if (LevelInfo == None) SetPropertyText("LevelInfo", "MyLevel.LevelInfo2");
		if (LevelInfo == None) return BadParameters("Please specify LevelInfo");
	}
	
	foreach LevelInfo.AllActors(class'Actor', actor) {
		if (!actor.bSelected) continue;
		if (a != None) return BadParameters("Error: more than 1 actor selected");
		a = actor;
	}
	if (a == None) return BadParameters("Error: please select 1 actor");
	LevelInfo.ConsoleCommand("EDITACTOR NAME="$a.Name);
	return false;
}

defaultproperties {
	BitmapFilename="EditActor"
	ToolTip="Call EditActor command for selected actor"
}
